/*!
  \file
  \brief 待機関数

  \author Satofumi KAMIMURA

  $Id: delay.cpp 1811 2010-04-30 16:12:05Z satofumi $
*/

#include "delay.h"
#include <QThread>


namespace
{
    static double delay_ratio_ = 1.0;

    class DelayThread : public QThread
    {
        int delay_msec_;

    public:
        DelayThread(int msec) : delay_msec_(msec)
        {
        }


        void run(void)
        {
            QThread::msleep(delay_msec_);
        }
    };
}


void qrk::delay(int msec)
{
    int delay_msec = static_cast<int>(msec * delay_ratio_);
    if (delay_msec > 0) {
        DelayThread delay_thread(delay_msec);
        delay_thread.run();
        delay_thread.wait();
    }
}
