-- Lua スクリプトの利用サンプル
-- $Id: luaSample.lua 1688 2010-02-11 23:10:16Z satofumi $

-- 接続
local run = mBeegoDrive()
if not run:connect("/dev/usb/ttyUSB0", 115200) then
   print("BeegoDrive::connect", run:what())
   return 1
end

local urg = mUrgDistance()
if not urg:connect("/dev/ttyACM0", 115200) then
   print("UrgDistance::connect", urg:what())
   return 1
end


-- 移動開始
run:followLine(0, 0, deg(0), nil)

-- 前方の障害物を検出したら停止
local StopDistance = 500        -- [mm]
local front_index = urg:deg2index(0)
repeat
   urg:requestData()
   urg:receiveData()
   local front_length = urg:at(front_index)
   print(front_length .. " [mm]")
until front_length < StopDistance

run:stop()
