#ifndef QRK_URG_DEVICE_DEVICE_H
#define QRK_URG_DEVICE_DEVICE_H

/*!
  \file
  \brief UrgDevice のシミュレータ

  \author Satofumi KAMIMURA

  $Id: UrgDevice_device.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include "Device.h"
#include "OdeModel.h"


namespace qrk
{
  //! UrgDevice のシミュレータ
  class UrgDevice_device : public Device, public OdeModel
  {
  public:
    UrgDevice_device(const char* device);
    ~UrgDevice_device(void);

    void setParameter(const char* type, const char* parameter);
    void activate(void);

    void execute(void);
    size_t nextExecuteInterval(void) const;

    void setPosition(const Position<long>& position,
                     OdeModel* model = NULL, bool fixed = true);
    Position<long> position(void);

    void setPosition3d(const Point3d<long>& position,
                       double ax, double ay, double az,
                       const Angle& angle,
                       OdeModel* model = NULL, bool fixed = true);

    void position3d(long& px, long& py, long& pz,
                    double& dx, double& dy, double& dz);

    dBodyID objectId(void) const;

  private:
    UrgDevice_device(const UrgDevice_device& rhs);
    UrgDevice_device& operator = (const UrgDevice_device& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_URG_DEVICE_DEVICE_H */
