#ifndef QRK_BOX_H
#define QRK_BOX_H

/*!
  \file
  \brief シミュレーション用の障害物(Box)

  \author Satofumi KAMIMURA

  $Id: Box.h 1474 2009-11-01 05:33:08Z satofumi $
*/


#include "OdeModel.h"
#include <memory>


namespace qrk
{
  class Color;


  class Box : public OdeModel
  {
    Box(void);
    Box(const Box& rhs);
    Box& operator = (const Box& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;

  public:
    Box(long x, long y, long z, dReal mass = 1.0);
    ~Box(void);

    void setPosition(const Position<long>& position,
                     OdeModel* model = NULL, bool fixed = false);
    Position<long> position(void);

    void setPosition3d(const Point3d<long>& position,
                       double ax, double ay, double az,
                       const Angle& angle,
                       OdeModel* model = NULL, bool fixed = true);

    void position3d(long& px, long& py, long& pz,
                    double& dx, double& dy, double& dz);

    void setColor(const Color& color);

    dBodyID objectId(void) const;
  };
}

#endif /* !QRK_BOX_H */
