/*!
  \file
  \brief エンコーダ制御

  \author Satofumi KAMIMURA

  $Id: encoder_control.cpp 1628 2010-01-18 00:30:05Z satofumi $
*/

#include "encoder_control.h"
#include "BeegoModel.h"

using namespace qrk;


namespace
{
  BeegoModel* model_ = NULL;
}


void encoder_setModel(BeegoModel* model)
{
  model_ = model;
}


void encoder_initialize(int id, encoder_t *encoder)
{
  encoder->id = id;
}


void encoder_reset(encoder_t *encoder)
{
  (void)encoder;

  // !!! カウンタをリセットする
}


void encoder_update(encoder_t *encoder)
{
  encoder->difference = model_->encoderCount(encoder->id);
}


short encoder_difference(const encoder_t *encoder)
{
  return encoder->difference;
}


unsigned long encoder_count(int id)
{
  (void)id;

  // !!!

  return 0;
}
