#ifndef QRK_BEEGO_DRIVE_DEVICE_H
#define QRK_BEEGO_DRIVE_DEVICE_H

/*!
  \file
  \brief BeegoDrive のシミュレータ

  \author Satofumi KAMIMURA

  $Id: BeegoDrive_device.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include "Device.h"
#include "OdeModel.h"


namespace qrk
{
  class BeegoDrive_device : public Device, public OdeModel
  {
  public:
    BeegoDrive_device(const char* device);
    ~BeegoDrive_device(void);

    void setParameter(const char* type, const char* parameter);
    void activate(void);

    void execute(void);
    size_t nextExecuteInterval(void) const;

    void setPosition(const Position<long>& position,
                     OdeModel* model = NULL, bool fixed = false);
    Position<long> position(void);

    void setPosition3d(const Point3d<long>& position,
                       double ax, double ay, double az,
                       const Angle& angle,
                       OdeModel* model = NULL, bool fixed = false);

    void position3d(long& px, long& py, long& pz,
                    double& dx, double& dy, double& dz);

    dBodyID objectId(void) const;

  private:
    BeegoDrive_device(const BeegoDrive_device& rhs);
    BeegoDrive_device& operator = (const BeegoDrive_device& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_BEEGO_DRIVE_DEVICE_H */
