#ifndef QRK_MARKER_MANAGER_H
#define QRK_MARKER_MANAGER_H

/*!
  \file
  \brief マーカーの管理

  \author Satofumi KAMIMURA

  $Id: MarkerManager.h 1440 2009-10-23 07:13:28Z satofumi $
*/

#include "ModelManager.h"
#include "Point.h"
#include <vector>


namespace qrk
{
  //! マーカーの描画クラス
  class MarkerManager
  {
  public:
    enum {
      Infinity = -1,
      DefaultWidth = 6,
    };

    MarkerManager(void);
    ~MarkerManager(void);

    void lock(void);
    void unlock(void);

    void clear(void);
    void clear(const char* name);
    void draw(const char* name, const ModelManager::model_t* model,
              int height = 10);
    void drawModels(const char* name, const ModelManager::model_t models[],
                    size_t n, int height = 10);

    void drawPoint(const char* name, const Point<long>& point,
                   const Color& color, int radius = DefaultWidth,
                   long height = 10);
    void drawPoints(const char* name, const std::vector<Point<long> >& points,
                    const Color& color, int radius = DefaultWidth,
                    long height = 10);
    void drawLines(const char* name, const std::vector<Point<long> >& points,
                   const Color& color, int width = DefaultWidth,
                   int height = 10);
    void drawLinesStrip(const char* name,
                        const std::vector<Point<long> >& points,
                        const Color& color, int width = DefaultWidth,
                        int height = 10);
    void drawArrows(const char* name, const std::vector<Point<long> >& points,
                    const Color& color, int width = DefaultWidth,
                    int height = 10);
    void drawArrowsStrip(const char* name,
                         const std::vector<Point<long> >& points,
                         const Color& color, int width = DefaultWidth,
                         int height = 10);

  private:
    MarkerManager(const MarkerManager& rhs);
    MarkerManager& operator = (const MarkerManager& rhs);

    struct pImpl;
    pImpl* pimpl;
  };
}

#endif /* !QRK_MARKER_MANAGER_H */
