#ifndef QRK_DRAW_ENVIRONMENT_WIDGET_H
#define QRK_DRAW_ENVIRONMENT_WIDGET_H

/*!
  \file
  \brief シミュレーション環境の描画

  \author Satofumi KAMIMURA

  $Id: DrawEnvironmentWidget.h 1414 2009-10-14 23:14:02Z satofumi $
*/

#include <QGLWidget>
#include <memory>


namespace qrk
{
  //! シミュレーション環境の描画クラス
  class DrawEnvironmentWidget : public QGLWidget
  {
  protected:
    void initializeGL(void);
    void resizeGL(int width, int height);
    void paintGL(void);
    //void mousePressEvent(QMouseEvent *event);
    //void mouseMoveEvent(QMouseEvent *event);
    void wheelEvent(QWheelEvent* event);

    QSize minimumSizeHint(void) const;

  public:
    DrawEnvironmentWidget(QWidget* parent = 0);
    ~DrawEnvironmentWidget(void);

    void setWireframeMode(bool on);

    void redraw(void);

  private:
    DrawEnvironmentWidget(const DrawEnvironmentWidget& rhs);
    DrawEnvironmentWidget& operator = (const DrawEnvironmentWidget& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_DRAW_ENVIRONMENT_WIDGET_H */
