#ifndef QRK_DEVICE_H
#define QRK_DEVICE_H

/*!
  \file
  \brief シミュレーション対象のインターフェース定義

  \author Satofumi KAMIMURA

  $Id: Device.h 1386 2009-10-09 08:00:11Z satofumi $
*/

#include "Coordinate.h"


namespace qrk
{
  class OdeModel;


  //! デバイス
  class Device : public Coordinate
  {
  public:
    enum {
      PortRetryMax = 10,
    };


    virtual ~Device(void)
    {
    }


    virtual void setParameter(const char* type, const char* parameter) = 0;
    virtual void activate(void) = 0;

    virtual void execute(void) = 0;
    virtual size_t nextExecuteInterval(void) const = 0;
  };
}

#endif /* !QRK_DEVICE_H */
