#ifndef SCI_CONTROL_H
#define SCI_CONTROL_H

/*!
  \file
  \brief SCI の制御

  \author Satofumi KAMIMURA

  $Id: sci_control.h 1649 2010-01-27 03:37:43Z satofumi $
*/

#include <stdbool.h>


/*!
  \brief SCI の初期化

  \param[in] priority 割り込み優先度
  \param[in] baudrate ボーレート [bps]
*/
extern void sci_initialize(unsigned char priority, long baudrate);


/*!
  \brief 送信

  \param[in] data 送信データ
  \param[in] size 送信バイト数

  \return 送信バイト数
*/
extern int sci_send(const char* data, int size);


/*!
  \brief 受信

  \param[out] data 受信データ
  \param[in] size 受信バイト数の最大値

  \return 受信バイト数
*/
extern int sci_receive(char* data, int size);


// !!! 受信バッファの空き容量を返す関数
extern int sci_readableSize(void);


// !!! 送信バッファの空き容量を返す関数
extern int sci_sendableSize(void);


// !!! 送信しているかを返す関数
extern bool sci_isSending(void);

#endif /* !SCI_CONTROL_H */
