/*!
  \file
  \brief LED 制御

  \author Satofumi KAMIMURA

  $Id: led_control.c 1624 2010-01-16 15:11:26Z satofumi $
*/

#include "led_control.h"
#include <7125S.H>


void led_initialize(void)
{
  // !!! LED に関係あるレジスタのみ初期化するようにする
  PFC.PECRL4.WORD = 0x0000;
  PFC.PECRL3.WORD = 0x0000;
  PFC.PECRL2.WORD = 0x0000;
  PFC.PECRL1.WORD = 0x0000;
  PFC.PEIORL.WORD = 0xff33;

  // 消灯させる
  int i;
  for (i = 0; i < 2; ++i) {
    led_set(i, false);
  }
}


void led_set(int id, bool on)
{
  if (id == 0) {
    if (on) {
      PE.DRL.WORD |= 0x0001;
    } else {
      PE.DRL.WORD &= ~0x0001;
    }
  } else if (id == 1) {
    if (on) {
      PE.DRL.WORD |= 0x0002;
    } else {
      PE.DRL.WORD &= ~0x0002;
    }
  }
}
