#ifndef CMT_CONTROL_H
#define CMT_CONTROL_H

/*!
  \file
  \brief タイマー制御

  \author Satofumi KAMIMURA

  $Id: cmt_control.h 1616 2010-01-15 12:32:34Z satofumi $
*/


/*!
  \brief タイマーの初期化

  \param[in] priority 割り込み優先度
*/
extern void cmt_initialize(unsigned char priority);


/*!
  \brief タイマー周期の設定

  \param[in] usec タイマー周期
  \param[in] function 割り込み関数
*/
extern void cmt_setInterval(int usec, void (*function)(void));


/*!
  \brief タイマーの動作開始
*/
extern void cmt_start(void);


/*!
  \brief タイマーの停止
*/
extern void cmt_stop(void);

#endif /* !CMT_CONTROL_H */
