/*!
  \file
  \brief エコーバックプログラム

  \author Satofumi KAMIMURA

  $Id: echoback.c 1041 2009-06-18 23:11:55Z satofumi $
*/

#include "sci_put.h"
#include "sci_get.h"
#include "imask_control.h"


enum { PORT = SCI_1 };

int main(void)
{
  sci_initialize(PORT, 4);
  imask_setMaskLevel(0);

  sci_puts(PORT, "echoback program begin.\r\n");

  while (1) {
    char ch;
    int i = sci_read(PORT, &ch, 1);
    if (ch >= 'a' && ch <= 'z') {
      ch += 'A' - 'a';
    }
    if (i > 0) {
      sci_write(PORT, &ch, 1);
    }
  }

  return 0;
}
