/*
  TCP/IP ʐM
  Satofumi KAMIMURA
  $Id: tcpipDevice.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#include "tcpipDevice.h"
#include <stdlib.h>
#include <list>

#ifndef SocketSetBaseNum
#define SocketSetBaseNum 1
#endif


#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
bool TcpipDevice::initialized = false;
int TcpipDevice::sockets_num = 0;
int TcpipDevice::sockets_max = SocketSetBaseNum;
SDLNet_SocketSet TcpipDevice::socket_set;
std::list<TCPsocket> stored_sockets;
#endif


void TcpipDevice::resizeSocketSet(void) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  SDLNet_FreeSocketSet(socket_set);
  sockets_max <<= 1;
  socket_set = SDLNet_AllocSocketSet(sockets_max);
  for (std::list<TCPsocket>::iterator it = stored_sockets.begin();
       it != stored_sockets.end(); ++it) {
    SDLNet_TCP_AddSocket(socket_set, *it);
  }
#endif
}


#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
void TcpipDevice::addSocket(TCPsocket socket) {
  if (own_set) {
    SDLNet_TCP_AddSocket(own_set, socket);
  } else {
    if (sockets_num >= sockets_max) {
      resizeSocketSet();
    }
    SDLNet_TCP_AddSocket(socket_set, socket);
    stored_sockets.push_back(socket);
    ++sockets_num;
  }
}


void TcpipDevice::delSocket(TCPsocket socket) {
  stored_sockets.remove(socket);
  SDLNet_TCP_DelSocket(socket_set, socket);
  --sockets_num;
}


int TcpipDevice::checkAllSockets(long timeout) {
  return SDLNet_CheckSockets(socket_set, timeout);
}
#endif


int TcpipDevice::checkSocket(long timeout) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  if (!own_set) {
    return checkAllSockets(timeout);
  } else {
    return SDLNet_CheckSockets(own_set, timeout);
  }
#else
  return -1;
#endif
}


void TcpipDevice::initialize(bool eachCheckSocket) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  if (!initialized) {
    if (SDLNet_Init() < 0) {
      return;
    }
    atexit(SDLNet_Quit);

    sockets_num = 0;
    sockets_max = SocketSetBaseNum;
    socket_set = SDLNet_AllocSocketSet(sockets_max);

    initialized = true;
  }

  if (eachCheckSocket) {
    own_set = SDLNet_AllocSocketSet(1);
  }
#endif
}


TcpipDevice::TcpipDevice(int buffer_size, bool eachCheckSockets)
  : SDL_Base(), ConnectionDevice(buffer_size)
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  , tcp_socket(NULL), own_set(NULL)
#endif
{
  initialize(eachCheckSockets);
}


TcpipDevice::TcpipDevice(bool eachCheckSockets)
  : SDL_Base()
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
    , tcp_socket(NULL), own_set(NULL)
#endif
{
  initialize(eachCheckSockets);
}


#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
TcpipDevice::TcpipDevice(TCPsocket net_socket, bool eachCheckSockets,
			 int buffer_size)
  : SDL_Base(), ConnectionDevice(buffer_size),
    tcp_socket(net_socket), own_set(NULL) {
  initialize(eachCheckSockets);
}
#endif


TcpipDevice::~TcpipDevice(void) {
  raw_disconnect();
}


const char* TcpipDevice::what(void) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  return SDLNet_GetError();
#else
  return "SDL_net is not installed.";
#endif
}


bool TcpipDevice::isConnected(void) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  return (tcp_socket) ? true : false;
#else
  return false;
#endif
}


int TcpipDevice::raw_connect(const char* host, long port) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  if (!initialized) {
    return LibraryInitFail;
  }

  IPaddress ip;
  SDLNet_ResolveHost(&ip, host, static_cast<short>(port));
  tcp_socket = SDLNet_TCP_Open(&ip);
  if (!tcp_socket) {
    disconnect();
    return DeviceOpenFail;
  }
  addSocket(tcp_socket);

  return 0;
#else
  return -1;
#endif
}


void TcpipDevice::raw_disconnect(void) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  if (own_set) {
    SDLNet_FreeSocketSet(own_set);
    own_set = NULL;
  }
  if (tcp_socket) {
    delSocket(tcp_socket);
    SDLNet_TCP_Close(tcp_socket);
    tcp_socket = NULL;
  }
#endif
}


int TcpipDevice::raw_setBaudrate(long baudrate) {
  return 0;
}


int TcpipDevice::raw_send(const char* data, int len) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
#if 0
  for (int i = 0; i < len; ++i) {
    if (data[i] == '\r') {
      fprintf(stderr, "\n");
    } else {
      fprintf(stderr, "%c", data[i]);
    }
  }
#endif
  return SDLNet_TCP_Send(tcp_socket, const_cast<char*>(data), len);
#else
  return 0;
#endif
}


void TcpipDevice::raw_flush(void) {
}


void TcpipDevice::raw_check(int size, long timeout) {
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  checkSocket(timeout);
  if (isConnected() && SDLNet_SocketReady(tcp_socket)) {
    char buffer[BufferSize];
    int n = SDLNet_TCP_Recv(tcp_socket, buffer, size);
    if (n <= 0) {
      disconnect();
      return;
    }
    recv_buffer->put(buffer, n);
  }
#endif
}
