#ifndef PEER_CONNECTION_H
#define PEER_CONNECTION_H

/*!
  \file
  \brief TCP/IP ̑ݐڑNX
  
  \author Satofumi KAMIMURA
  
  $Id: peerConnection.h 286 2008-10-20 09:40:22Z satofumi $
*/

#include "tcpipDevice.h"

/*!
  \brief P΂PڑNX
*/
class PeerConnection : public ConnectionDevice {
  TcpipDevice* con;
  std::string error_message;
  PeerConnection(const PeerConnection& rhs);

  int raw_connect(const char* device, long baudrate);
  void raw_disconnect(void);
  int raw_send(const char* data, int len);
  int raw_recv(char* data, int maxlen);
  int raw_setBaudrate(long baudrate) { return 0; }
  void raw_flush(void) {}
  void raw_check(int size, long timeout);

public:
  PeerConnection(void);
  ~PeerConnection(void);

  const char* what(void);

  /*!
    \brief ڑ

    \param host [i] ڑzXg
    \param port [i] ڑ|[g
    \param timeout [i] ^CAEg [msec]
  */
  int connect(const char* host, long port, long timeout);
  bool isConnected(void);
  int recv(char* data, int maxlen, long timeout);
};

#endif /* !PEER_CONNECTION_H */
