#ifndef FILE_2_LINE_H
#define FILE_2_LINE_H

/*!
  \file
  \brief t@C̐l X,Y ̃yAƌȂ Grid 𐶐Bsŋ؂

  \author Satofumi KAMIMURA

  $Id: file2Line.h 286 2008-10-20 09:40:22Z satofumi $
*/

#include "typeUtils.h"
#include <fstream>
#include <iterator>


namespace VXV {
  /*!
    \brief t@C璼p̃f[^o͂

    \param v [o] Grid i[ vector
    \param fname [i] t@C
  */
  template<class T> void File2Line(std::vector<std::vector<T> >& v,
				   const char* fname) {
    std::ifstream from(fname);

    std::vector<T> line;
    int pre_x = 0, pre_y = 0;
    for (std::istream_iterator<int> it(from);
	 it != std::istream_iterator<int>();) {
      int x = *it++;
      if (it == std::istream_iterator<int>()) {
	break;
      }
      int y = *it++;
      if (line.empty() || ((pre_x != x) || (pre_y != y))) {
	line.push_back(T(x, y));
      } else if (line.size() > 1) {
	v.push_back(line);
	line.clear();
      }
      pre_x = x;
      pre_y = y;
    }
  };
}

#endif /* !FILE_2_LINE_H */
