#ifndef TYPE_UTILS_TEST_H
#define TYPE_UTILS_TEST_H

/*!
  \file
  \brief typeUtils.cpp ̃eXg
  
  \author Satofumi KAMIMURA
  
  $Id: TypeUtilsTest.h 286 2008-10-20 09:40:22Z satofumi $
*/

#include <cppunit/extensions/HelperMacros.h>

/*!
  \todo Position3D ̃eXgɁApxZǉ
  \todo length() ̃eXgǉ
  \todo Matrix4D ̃eXgǉ
*/
class TypeUtilsTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(TypeUtilsTest);
  CPPUNIT_TEST(Grid2DTest);
  CPPUNIT_TEST(Grid3DTest);
  CPPUNIT_TEST(DirectionTest);
  CPPUNIT_TEST(RectTest);
  CPPUNIT_TEST(PositionTest);
  CPPUNIT_TEST(Position3DTest);
  CPPUNIT_TEST_SUITE_END();

public:
  void Grid2DTest(void);
  void Grid3DTest(void);
  void DirectionTest(void);
  void RectTest(void);
  void PositionTest(void);
  void Position3DTest(void);
};

#endif /* !TYPE_UTILS_TEST_H */
