/*
  propertyInfo.cpp ̃eXg
  Satofumi KAMIMURA
  $Id: PropertyInfoTest.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#include "PropertyInfoTest.h"
#include "propertyInfo.h"
#include <unistd.h>

CPPUNIT_TEST_SUITE_REGISTRATION(PropertyInfoTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(PropertyInfoTest, "PropertyInfoTest");


static int c_value = 0;
static std::string e_str;

class PropertySample : public PropertyInfo {
public:
  int a;
  int b;
  int c;
  std::string d;
  std::string e;

  void evaluate(void) {
    value(&a, "a_value", 1);
    value(&b, "b_value", 2);
    value(&c, "c_value", 0);
    value(d, "d_str", "str");
    value(e, "e_str", "0");
  }
};



void PropertyInfoTest::createTest(void) {
  PropertySample obj;

  const char* searchPath[] = { ".", NULL };
  obj.load(".propertyrc", searchPath);
  obj.save();
}


void PropertyInfoTest::readTest(void) {
  PropertySample obj;

  const char* searchPath[] = { ".", NULL };
  obj.load(".propertyrc", searchPath);

  CPPUNIT_ASSERT_EQUAL(1, obj.a);
  CPPUNIT_ASSERT_EQUAL(2, obj.b);
  CPPUNIT_ASSERT_EQUAL(std::string("str"), obj.d);

  // l̍XV
  ++obj.c;
  c_value = obj.c;

  // ̍XV
  obj.e[0] = '0' + obj.c % 10;
  e_str = obj.e;

  obj.save();
}


void PropertyInfoTest::writeTest(void) {
  PropertySample obj;

  const char* searchPath[] = { ".", NULL };
  obj.load(".propertyrc", searchPath);

  CPPUNIT_ASSERT_EQUAL(1, obj.a);
  CPPUNIT_ASSERT_EQUAL(2, obj.b);
  CPPUNIT_ASSERT_EQUAL(c_value, obj.c);
  CPPUNIT_ASSERT_EQUAL(std::string("str"), obj.d);
  CPPUNIT_ASSERT_EQUAL(e_str, obj.e);
}


void PropertyInfoTest::createDirTest(void) {
  PropertySample obj;

  const char* searchPath[] = { "./conf/conf2/", NULL };
  obj.load(".propertyrc2", searchPath);
  obj.save();
  CPPUNIT_ASSERT_EQUAL(0, access("./conf/conf2/.propertyrc2", R_OK));

  PropertySample obj2;
  obj2.load(".propertyrc2", searchPath);

  CPPUNIT_ASSERT_EQUAL(1, obj2.a);
  CPPUNIT_ASSERT_EQUAL(2, obj2.b);
  obj2.save();
}
