/*!
  \file
  \brief ^[Qbgp̑svO

  \author Satofumi KAMIMURA

  $Id: tRunCtrl.c 286 2008-10-20 09:40:22Z satofumi $
*/

#include "tRunCtrl.h"
#include "taskCtrl.h"
#include "transferCtrl.h"
#include "sh7045lib.h"
#include "packetHandleTarget.h"


static runCtrl_t Run;


static void msecHandler(void) {
  update_tRunCtrlState(&Run);
}


void __main(void) {}
int main(void) {
  nodeInfo_t node;
  int port;

  initTransferCtrl(SCI_0);
  initTransferCtrl(SCI_1);
  init_timer(INT_MTU_LEVEL);
  set_imask(0);

  init_tRunCtrlState(&Run, PACKAGE_NUM_VERSION);
  initNodeInfo(&node);
  registerStructInfo(&node, (unsigned char *)&Run, RUN_CTRL_TARGET_ID);

  set_timerHandler(msecHandler, SMP_USEC);
  start_timer(SMP_USEC);

  while (1) {
    if (get_sciReadable(SCI_0)) {
      port = SCI_0;
      break;
    } else if (get_sciReadable(SCI_1)) {
      port = SCI_1;
      break;
    }
  }
  trans_setPort(port);
  reset_tRunCtrlPosition(&Run);

  while (1) {
    packetRecvHandler(&Run);
  }
}
