/*
  \brief ^ atan2()

  Integer Arc Tangent program ( iatan2()
  !!! Attention.  This program generated by create_iatan2.rb. !!!

  \author Satofumi KAMIMURA

  $Id: iatan2.c 286 2008-10-20 09:40:22Z satofumi $

  angle_max = 65535

  ݂̎ł́A33/65535 ȓ̌덷B
  ꉞA2^(31-13) ܂ł̋ X, Y ɂĎg͂
*/

#include "iatan2.h"

static short atan2_table[] = {
0, 25, 50, 75, 101, 126, 151, 176, 201, 226, 
251, 277, 302, 327, 352, 377, 402, 428, 453, 478, 
503, 529, 554, 579, 604, 630, 655, 680, 705, 731, 
756, 781, 807, 832, 858, 883, 908, 934, 959, 985, 
1010, 1036, 1061, 1087, 1113, 1138, 1164, 1189, 1215, 1241, 
1267, 1292, 1318, 1344, 1370, 1396, 1421, 1447, 1473, 1499, 
1525, 1551, 1577, 1603, 1629, 1656, 1682, 1708, 1734, 1761, 
1787, 1813, 1840, 1866, 1892, 1919, 1945, 1972, 1999, 2025, 
2052, 2079, 2105, 2132, 2159, 2186, 2213, 2240, 2267, 2294, 
2321, 2348, 2376, 2403, 2430, 2458, 2485, 2512, 2540, 2568, 
2595, 2623, 2651, 2678, 2706, 2734, 2762, 2790, 2818, 2846, 
2875, 2903, 2931, 2960, 2988, 3016, 3045, 3074, 3102, 3131, 
3160, 3189, 3218, 3247, 3276, 3305, 3334, 3364, 3393, 3423, 
3452, 3482, 3512, 3541, 3571, 3601, 3631, 3661, 3692, 3722, 
3752, 3783, 3813, 3844, 3875, 3905, 3936, 3967, 3998, 4029, 
4061, 4092, 4124, 4155, 4187, 4218, 4250, 4282, 4314, 4346, 
4379, 4411, 4444, 4476, 4509, 4542, 4575, 4608, 4641, 4674, 
4707, 4741, 4774, 4808, 4842, 4876, 4910, 4944, 4979, 5013, 
5048, 5083, 5117, 5152, 5188, 5223, 5258, 5294, 5329, 5365, 
5401, 5437, 5474, 5510, 5547, 5583, 5620, 5657, 5695, 5732, 
5769, 5807, 5845, 5883, 5921, 5960, 5998, 6037, 6076, 6115, 
6154, 6193, 6233, 6273, 6313, 6353, 6393, 6434, 6474, 6515, 
6556, 6598, 6639, 6681, 6723, 6765, 6808, 6850, 6893, 6936, 
6979, 7023, 7066, 7110, 7155, 7199, 7244, 7289, 7334, 7379, 
7425, 7471, 7517, 7563, 7610, 7657, 7704, 7752, 7799, 7847, 
7896, 7944, 7993, 8043, 8092, 8142, 8192, 8193
};

static int atanValue(int y, int x, int sign_offset) {
    short *p = atan2_table;
    short v;
    int ret;
    int offset;

    short *first, *last, *pre;

    offset = (sign_offset < 0) ? -sign_offset : sign_offset ;

    if (x == 0) {
	;			/* T͕KvȂA擪̒l̂܂ܕԂ */
    } else {
	v = y * 8192 / x;
	v = (v < 0) ? -v : v;
	first = atan2_table;
	last = atan2_table + 256;

        do {
	    pre = p;
	    p = atan2_table + ((first-atan2_table) + (last-atan2_table)) / 2;
	    if (*p > v) {
	        last = p;
	    } else {
	        first = p;
	    }
	} while (p != pre);
    }
    ret = (int)((p - atan2_table) * 32);

    if (sign_offset < 0) {
	ret = offset - ret;
    } else {
	ret += offset;
    }

    return ret;
}

#define DEG(X) (int)(1.0 * 65536 * X / 360.0)

/*!
  \brief ^atan2()

  ^ atan2()B

  \Param y [i] Yl
  \param x [i] Xl

  \retval px[div16]
*/
int iatan2(int y, int x) {
    int ret;

    if (y >= 0) {
	if (x >= 0) {		/* Pی */
	    if (x >= y) {	/* 0-45[deg] */
		ret = atanValue(y, x, DEG(0));
	    } else {		/* 45-90[deg] */
		ret = atanValue(x, y, DEG(-90));
	    }
	} else {		/* Qی */
	    if (-x <= y) {	/* 90-135[deg] */
		ret = atanValue(x, y, DEG(90));
	    } else {		/* 135-180[deg] */
		ret = atanValue(y, x, DEG(-180));
	    }
	}
    } else {
	if (x < 0) {		/* Rی */
	    if (-x >= -y) {	/* 180-225[deg] */
		ret = atanValue(y, x, DEG(180));
	    } else {		/* 225-270[deg] */
		ret = atanValue(x, y, DEG(-270));
	    }
	} else {		/* Sی */
	    if (x <= -y) {	/* 270-315[deg] */
		ret = atanValue(x, y, DEG(270));
	    } else {		/* 315-360[deg] */
		ret = atanValue(y, x, -DEG(360));
	    }
	}
    }
    return ret;
}
