/*
  isincos.c ̃eXg
  Satofumi KAMIMURA
  $Id: IsincosTest.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#include "IsincosTest.h"
#include "isincos.h"
#include <math.h>

CPPUNIT_TEST_SUITE_REGISTRATION(IsincosTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(IsincosTest, "IsincosTest");


void IsincosTest::isincosTest(void) {

  for (int div16 = 0; div16 < 65536; ++div16) {
    CPPUNIT_ASSERT_EQUAL((int)(32768 * sin(2.0 * M_PI * div16 / 65536.0)),
			 isin(div16));
  }
  for (int div16 = 0; div16 < 65536; ++div16) {
    CPPUNIT_ASSERT_EQUAL((int)(32768 * cos(2.0 * M_PI * div16 / 65536.0)),
			 icos(div16));
  }
}
