OUTPUT_FORMAT("coff-sh")
OUTPUT_ARCH(sh)
MEMORY
{
  rom(wx)   : o = 0x00000000, l = 256K
  ram(rw)   : o = 0x00400000, l = 1M
  stack(rw) : o = 0xfffff000, l = 4K
}
SECTIONS
{
  .text :
  {
     _vec_ram = . ;
   LONG(ABSOLUTE(start0))	/* 0 */
   LONG(ABSOLUTE(_stack))	/* 1 */
   LONG(ABSOLUTE(start0))	/* 2 */
   LONG(ABSOLUTE(_stack))	/* 3 */
   LONG(DEFINED(_futou1)?ABSOLUTE(_futou1):ABSOLUTE(start0))	/* 4 */
   . += 4;							/* 5 */
   LONG(DEFINED(_futou2)?ABSOLUTE(_futou2):ABSOLUTE(start0))	/* 6 */
   . += 4*2;							/* 7,8 */
   LONG(DEFINED(_adderr1)?ABSOLUTE(_adderr1):ABSOLUTE(start0))	/* 9 */
   LONG(DEFINED(_adderr2)?ABSOLUTE(_adderr2):ABSOLUTE(start0))	/* 10 */
   LONG(DEFINED(_nmi)?ABSOLUTE(_num):ABSOLUTE(start0))		/* 11 */
   LONG(DEFINED(_usr)?ABSOLUTE(_usr):ABSOLUTE(start0))		/* 12 */
   . += 4*51;							/* 13-63 */
   LONG(DEFINED(_irq0)?ABSOLUTE(_irq0):ABSOLUTE(start0))	/* 64 */
   LONG(DEFINED(_irq1)?ABSOLUTE(_irq1):ABSOLUTE(start0))	/* 65 */
   LONG(DEFINED(_irq2)?ABSOLUTE(_irq2):ABSOLUTE(start0))	/* 66 */
   LONG(DEFINED(_irq3)?ABSOLUTE(_irq3):ABSOLUTE(start0))	/* 67 */
   LONG(DEFINED(_irq4)?ABSOLUTE(_irq4):ABSOLUTE(start0))	/* 68 */
   LONG(DEFINED(_irq5)?ABSOLUTE(_irq5):ABSOLUTE(start0))	/* 69 */
   LONG(DEFINED(_irq6)?ABSOLUTE(_irq6):ABSOLUTE(start0))	/* 70 */
   LONG(DEFINED(_irq7)?ABSOLUTE(_irq7):ABSOLUTE(start0))	/* 71 */
   LONG(DEFINED(_dmac0)?ABSOLUTE(_dmac0):ABSOLUTE(start0))	/* 72 */
   . += 4*3;							/* 73-75 */
   LONG(DEFINED(_dmac1)?ABSOLUTE(_dmac1):ABSOLUTE(start0))	/* 76 */
   . += 4*3;							/* 77-79 */
   LONG(DEFINED(_dmac2)?ABSOLUTE(_dmac2):ABSOLUTE(start0))	/* 80 */
   . += 4*3;							/* 81-83 */
   LONG(DEFINED(_dmac3)?ABSOLUTE(_dmac3):ABSOLUTE(start0))	/* 84 */
   . += 4*3;							/* 85-87 */
   LONG(DEFINED(_tgi0a)?ABSOLUTE(_tgi0a):ABSOLUTE(start0))	/* 88 */
   LONG(DEFINED(_tgi0b)?ABSOLUTE(_tgi0b):ABSOLUTE(start0))	/* 89 */
   LONG(DEFINED(_tgi0c)?ABSOLUTE(_tgi0c):ABSOLUTE(start0))	/* 90 */
   LONG(DEFINED(_tgi0d)?ABSOLUTE(_tgi0d):ABSOLUTE(start0))	/* 91 */
   LONG(DEFINED(_tgi0v)?ABSOLUTE(_tgi0v):ABSOLUTE(start0))	/* 92 */
   . += 4*3;							/* 93-95 */
   LONG(DEFINED(_tgi1a)?ABSOLUTE(_tgi1a):ABSOLUTE(start0))	/* 96 */
   LONG(DEFINED(_tgi1b)?ABSOLUTE(_tgi1b):ABSOLUTE(start0))	/* 97 */
   . += 4*2;							/* 98,99 */
   LONG(DEFINED(_tgi1c)?ABSOLUTE(_tgi1v):ABSOLUTE(start0))	/* 100 */
   LONG(DEFINED(_tgi1d)?ABSOLUTE(_tgi1u):ABSOLUTE(start0))	/* 101 */
   . += 4*2;							/* 102,103 */
   LONG(DEFINED(_tgi2a)?ABSOLUTE(_tgi2a):ABSOLUTE(start0))	/* 104 */
   LONG(DEFINED(_tgi2b)?ABSOLUTE(_tgi2b):ABSOLUTE(start0))	/* 105 */
   . += 4*2;							/* 106,107 */
   LONG(DEFINED(_tgi2c)?ABSOLUTE(_tgi2v):ABSOLUTE(start0))	/* 108 */
   LONG(DEFINED(_tgi2d)?ABSOLUTE(_tgi2u):ABSOLUTE(start0))	/* 109 */
   . += 4*2;							/* 110,111*/
   LONG(DEFINED(_tgi3a)?ABSOLUTE(_tgi3a):ABSOLUTE(start0))	/* 112 */
   LONG(DEFINED(_tgi3b)?ABSOLUTE(_tgi3b):ABSOLUTE(start0))	/* 113 */
   LONG(DEFINED(_tgi3c)?ABSOLUTE(_tgi3c):ABSOLUTE(start0))	/* 114 */
   LONG(DEFINED(_tgi3d)?ABSOLUTE(_tgi3d):ABSOLUTE(start0))	/* 115 */
   LONG(DEFINED(_tgi3v)?ABSOLUTE(_tgi3v):ABSOLUTE(start0))	/* 116 */
   . += 4*3;							/* 117-119 */
   LONG(DEFINED(_tgi4a)?ABSOLUTE(_tgi4a):ABSOLUTE(start0))	/* 120 */
   LONG(DEFINED(_tgi4b)?ABSOLUTE(_tgi4b):ABSOLUTE(start0))	/* 121 */
   LONG(DEFINED(_tgi4c)?ABSOLUTE(_tgi4c):ABSOLUTE(start0))	/* 122 */
   LONG(DEFINED(_tgi4d)?ABSOLUTE(_tgi4d):ABSOLUTE(start0))	/* 123 */
   LONG(DEFINED(_tgi4v)?ABSOLUTE(_tgi4v):ABSOLUTE(start0))	/* 124 */
   . += 4*3;							/* 125-127 */
   LONG(DEFINED(_eri0)?ABSOLUTE(_eri0):ABSOLUTE(start0))	/* 128 */
   LONG(DEFINED(_rxi0)?ABSOLUTE(_rxi0):ABSOLUTE(start0))	/* 129 */
   LONG(DEFINED(_txi0)?ABSOLUTE(_txi0):ABSOLUTE(start0))	/* 130 */
   LONG(DEFINED(_tei0)?ABSOLUTE(_tei0):ABSOLUTE(start0))	/* 131 */
   LONG(DEFINED(_eri1)?ABSOLUTE(_eri1):ABSOLUTE(start0))	/* 132 */
   LONG(DEFINED(_rxi1)?ABSOLUTE(_rxi1):ABSOLUTE(start0))	/* 133 */
   LONG(DEFINED(_txi1)?ABSOLUTE(_txi1):ABSOLUTE(start0))	/* 134 */
   LONG(DEFINED(_tei1)?ABSOLUTE(_tei1):ABSOLUTE(start0))	/* 135 */
   LONG(DEFINED(_adi)?ABSOLUTE(_adi):ABSOLUTE(start0))		/* 136 */
   . += 4*3;							/* 137-139 */
   LONG(DEFINED(_swdtce)?ABSOLUTE(_swdtce):ABSOLUTE(start0))	/* 140 */
   . += 4*3;							/* 141-143 */
   LONG(DEFINED(_cmi0)?ABSOLUTE(_cmi0):ABSOLUTE(start0))	/* 144 */
   . += 4*3;							/* 145-147 */
   LONG(DEFINED(_cmi1)?ABSOLUTE(_cmi1):ABSOLUTE(start0))	/* 148 */
   . += 4*3;							/* 149-151 */
   LONG(DEFINED(_iti)?ABSOLUTE(_iti):ABSOLUTE(start0))		/* 152 */
   LONG(DEFINED(_cmi)?ABSOLUTE(_cmi):ABSOLUTE(start0))		/* 153 */
   . += 4*2;							/* 154,155 */
   LONG(DEFINED(_oei)?ABSOLUTE(_oei):ABSOLUTE(start0))		/* 156 */

    *(.text)
    *(.strings)

     _etext = . ; 
  }  > rom
  .tors :
  AT ( ADDR(.text) + SIZEOF(.text) )
  {
    _cp_start = . ;
    ___ctors = . ;
    *(.ctors)
    ___ctors_end = . ;
    ___dtors = . ;
    *(.dtors)
    ___dtors_end = . ;
  } > ram
  .data :
  AT ( ADDR(.text) + SIZEOF(.text) + SIZEOF(.tors) )
  {
    *(.data)
     _edata = . ; 
     _cp_end = . ;
  }  > ram
  .bss :
  {
     _bss_start = . ; 
    *(.bss)
    *(COMMON)
     _end = . ;  
  }  > ram

  .stack  0x00400000+1M-0x10 (NOLOAD) :
  /*.stack  0xfffffff0 (NOLOAD) :*/
  {
     _stack = . ; 
    *(.stack)
  /*}  > stack*/
  }  > ram

  .stab 0 (NOLOAD) :
  {
    *(.stab)
  }
  .stabstr 0 (NOLOAD) :
  {
    *(.stabstr)
  }
}
