/*
  objCoordinateCtrl.cpp ̃eXg
  Satofumi KAMIMURA
  $Id: ObjCoordinateCtrlTest.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#include "ObjCoordinateCtrlTest.h"
#include "objCoordinateCtrl.h"
#include "typePrint.h"

using namespace VXV;

CPPUNIT_TEST_SUITE_REGISTRATION(ObjCoordinateCtrlTest);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(ObjCoordinateCtrlTest,
				      "ObjCoordinateCtrlTest");


void ObjCoordinateCtrlTest::compileTest(void) {
  ObjCoordinateCtrl run;
  CoordinateCtrl urg;
  CoordinateCtrl urg2;

  urg.setOwnCrdToObject(&run);
  urg2.setOwnCrdToCrd(&run);
}


class RunCtrlDummy : public ObjCoordinateCtrl {
  int times;
  Position3D getLocalPosition(void) {
    ++times;
    return Position(100 * times, 0, Direction::deg(times * 90));
  }
public:
  RunCtrlDummy(void) : times(0) {}
  ~RunCtrlDummy(void) {};
};


void ObjCoordinateCtrlTest::getCrdPositionTest(void) {
  RunCtrlDummy run;
  CoordinateCtrl urg;
  CoordinateCtrl urg2;

  urg.setOwnCrdToObject(&run);
  urg2.setOwnCrdToCrd(&run);

  // ȈʒumF
  Position3D expected = Position(0, 0, Direction::deg(0));
  CPPUNIT_ASSERT_EQUAL(expected, urg2.getCrdPosition());

  expected = Position(100, 0, Direction::deg(90));
  CPPUNIT_ASSERT_EQUAL(expected, urg.getCrdPosition());

  expected = Position(200, 0, Direction::deg(180));
  CPPUNIT_ASSERT_EQUAL(expected, urg.getCrdPosition());

  expected = Position(0, 0, Direction::deg(0));
  CPPUNIT_ASSERT_EQUAL(expected, urg2.getCrdPosition());

  expected = Position(300, 0, Direction::deg(270));
  CPPUNIT_ASSERT_EQUAL(expected, urg.getCrdPosition());
}


void ObjCoordinateCtrlTest::fsCrdPositionTest(void) {
  ObjCoordinateCtrl run;
  CoordinateCtrl fs;
  fs.setOwnCrdToObject(&run);

  Position fs_command = Position(1000, 0, VXV::Direction::deg(0));
  Position expected = Position(1000, 0, Direction::deg(0));
  Position actual = run.getCrdPosition(&fs, fs_command);
  CPPUNIT_ASSERT_EQUAL(expected, actual);

  run.adjustCrdPosition(Position(1000, 0, Direction::deg(90)));
  actual = run.getCrdPosition();
  CPPUNIT_ASSERT_EQUAL(Position(1000, 0, Direction::deg(90)), actual);

  expected = Position(1000, 1000, Direction::deg(90));
  actual = fs.getCrdPosition(NULL, fs_command);
  CPPUNIT_ASSERT_EQUAL(expected, actual);
}
