/*
  foCX̒ڐ
  Satofumi KAMIMURA
  $Id: directCmdCtrl.cpp 286 2008-10-20 09:40:22Z satofumi $
*/

#include "runCtrl.h"

using namespace VXV;


void RunCtrl::servoCtrl(bool on) {
  if (sendServoCtrl(on ? 1 : 0)) {
    throw RunCtrl_Exception("sendServoCtrl()");
  }
}


/*!
  \brief [^ PWM 𒼐ڎw

  \param id [i] [^ID
  \param duty [i] PWM [0, 255]
  \retval *this
*/
void RunCtrl::setMotorPwm(int id, unsigned char duty) {
  unsigned char duty_array[1] = { duty };
  if (sendMotorDuty(id, duty_array, 1) < 0) {
    throw RunCtrl_Exception("sendMotorDuty()");
  }
}

void RunCtrl::setMotorPwm(int id, unsigned char duty[], int num) {
  if (sendMotorDuty(id, duty, num) < 0) {
    throw RunCtrl_Exception("sendMotorDuty()");
  }
}


/*!
  \brief [^̐䃂[h𒼐ڎw

  w\ȃ[h́AFREE, CW, CWW ̂ꂩ

  \param id [i] [^ID
  \param mode [i] [^̃[h
  \retval *this
*/
void RunCtrl::setMotorMode(int id, unsigned char mode) {
  unsigned char mode_array[1] = { mode };
  if (sendMotorMode(id, mode_array, 1) < 0) {
    throw RunCtrl_Exception("sendMotorMode()");
  }
}

void RunCtrl::setMotorMode(int id, unsigned char mode[], int num) {
  if (sendMotorMode(id, mode, num) < 0) {
    throw RunCtrl_Exception("sendMotorMode()");
  }
}


/*!
  \brief GR[_x̎擾

  1 [msec]̃GR[_l̕ωʂ擾

  \param id [i] GR[_ID
  \param cnt [o] GR[_l̕ψ [1]
  \retval *this
*/
void RunCtrl::getEncoderVel(int id, int *cnt) {
  int cnt_array[1];
  if (recvEncoderDiff(id, cnt_array, 1) < 0) {
    throw RunCtrl_Exception("recvEncoderDiff()");
  }
  *cnt = cnt_array[0];
}

void RunCtrl::getEncoderVel(int id, int cnt[], int num) {
  if (recvEncoderDiff(id, cnt, num) < 0) {
    throw RunCtrl_Exception("recvEncoderDiff()");
  }
}


/*!
  \brief GR[_JE^l̎擾

  _ł̃GR[_JE^l擾

  \param id [i] GR[_ID
  \param cnt [o] GR[_̃JE^l [1]
  \retval *this

  \attention 擾ԊuɂẮAGR[_̃I[o[t[ołȂ
*/
void RunCtrl::getEncoderValue(int id, unsigned short *cnt) {
  unsigned short cnt_array[1];
  if (recvEncoderValue(id, cnt_array, 1) < 0) {
    throw RunCtrl_Exception("recvEncoderValue()");
  }
  *cnt = cnt_array[0];
}

void RunCtrl::getEncoderValue(int id, unsigned short cnt[], int num) {
  if (recvEncoderValue(id, cnt, num) < 0) {
    throw RunCtrl_Exception("recvEncoderValue()");
  }
}


/*!
  \brief ԗւ̈ړx𒼐ڎw

  \param id [i] ԗID
  \param mm_vel [i] ԗւ̈ړx [mm/sec]
  \retval *this
*/
void RunCtrl::setWheelVel(int id, int mm_vel) {
  int mm_vel_array[1] = { mm_vel };
  if (sendWheelVel(id, mm_vel_array, 1) < 0) {
    throw RunCtrl_Exception("sendWheelVel()");
  }
}

void RunCtrl::setWheelVel(int id, int mm_vel[], int num) {
  if (sendWheelVel(id, mm_vel, num) < 0) {
    throw RunCtrl_Exception("sendWheelVel()");
  }
}
