/*!
  \file
  \example pwm_setDuty.c PWM の出力サンプル

  \author Satofumi KAMIMURA

  $Id: pwm_setDuty.c 1932 2010-10-02 21:46:01Z satofumi $
*/

#include "mtu_control.h"
#include "pwm_control.h"
#include "led_control.h"


static void wait(void)
{
  volatile int i;

  for (i = 0; i < 4000000; ++i) {
    ;
  }
}


int main(void)
{
  led_initialize();
  mtu_initialize();

  unsigned char duty = 64;
  int i;
  for (i = 0; i < 2; ++i) {
    pwm_initialize(i);

    pwm_set(i, PwmMode_CW, duty);
    //pwm_set(i, PwmMode_CCW, duty);
    //pwm_setMode(i, PwmMode_Stop, 0);
    //pwm_setMode(i, PwmMode_Free, 0);
  }

  while (1) {
    led_set(0, true);
    led_set(1, false);
    wait();

    led_set(0, false);
    led_set(1, true);
    wait();
  }
}
