/*!
  \example motor_graph.c Duty-RPM 相当のグラフ作成サンプル

  Duty 比を変更しながらモータの回転速を記録し、結果を出力する

  \author Satofumi KAMIMURA

  $Id: motor_graph.c 1677 2010-02-07 13:59:59Z satofumi $
*/

#include "mtu_control.h"
#include "encoder_control.h"
#include "pwm_control.h"
#include "led_control.h"
#include "sci_control.h"
#include "sci_put.h"
#include "cmt_control.h"
#include "imask_control.h"


enum {
  DutyMax = 256,
};


// データ記録用のバッファ
static char count_data_[DutyMax];


static encoder_t encoder_;


// グラフ用の数値を出力
static void output(void)
{
  int i;
  for (i = 0; i < DutyMax; ++i) {
    sci_putint(i);
    sci_puts(", ");
    sci_putint(count_data_[i]);
    sci_puts("\r\n");

    while (sci_isSending()) {
      ;
    }
  }
}


// Duty 比を変更して 5 [msec] 後にエンコーダ変位を記録する
static void timer_handler(void)
{
  static int msec = 0;
  static int record_times = 0;

  // データの記録が完了したら、結果を出力して終了
  if (record_times >= DutyMax) {
    output();

    // 停止
    pwm_set(0, PwmMode_Free, 0);

    // 終了
    while (1) {
      ;
    }
  }

  // エンコーダ変位の更新
  encoder_update(&encoder_);
  count_data_[record_times] = encoder_difference(&encoder_);

  if (++msec > 2) {

    msec = 0;
    ++record_times;

    pwm_set(0, PwmMode_CW, record_times);
  }
}


int main(void)
{
  sci_initialize(6, 38400);
  mtu_initialize();
  encoder_initialize(0, &encoder_);
  cmt_initialize(4);
  imask_setMaskLevel(0);

  pwm_initialize(0);

  pwm_set(0, PwmMode_Free, 0);

  cmt_setInterval(10000, timer_handler);
  cmt_start();

  while (1) {
    ;
  }
}
