/*!
  \file
  \brief 自作ロボットの制御

  \author Satofumi KAMIMURA

  $Id: myrobot_drive.c 1619 2010-01-15 14:29:21Z satofumi $
*/

#include "robot_control.h"
#include "packet_handler.h"
#include "cmt_control.h"
#include "imask_control.h"
#include "interrupt_priority.h"


int main(void)
{
  // 初期化
  robot_t robot;
  robot_initialize(&robot);
  cmt_initialize(CMT_Priority);

  // 制御の開始
  enum {
    ControlInterval = 1000,     //!< [usec]
  };
  cmt_setInterval(ControlInterval, robot_update);
  imask_setMaskLevel(0);
  cmt_start();

  packet_initialize(&robot);
  while (1) {
    // 通信処理
    packet_update();
  }
}
