#ifndef WHEEL_CONTROL_H
#define WHEEL_CONTROL_H

/*!
  \file
  \brief 車輪制御

  \author Satofumi KAMIMURA

  $Id: wheel_control.h 1191 2009-07-30 05:52:49Z satofumi $
*/

#include "wheel_t.h"


extern void wheel_initialize(wheel_t *wheel);
extern void wheel_reset(wheel_t *wheel);


/*!
  \brief 1 [msec] あたりのモータ回転数を計算する

  モータ回転数は、1回転するときを 32768 の値で表現する。

  \param[in] mm_per_sec 車輪の移動速度 [mm/sec]
  \param[in] wheel モータのパラメータ

  \return 1 [msec] あたりのモータ回転数
*/
extern long wheel_calculateMotorVelocity(int mm_per_sec, const wheel_t *wheel);

#endif /* !WHEEL_CONTROL_H */
