#ifndef POSITION_CALCULATE_H
#define POSITION_CALCULATE_H

/*!
  \file
  \brief 自己位置の計算

  \author Satofumi KAMIMURA

  $Id: position_calculate.h 1216 2009-08-09 08:35:00Z satofumi $
*/

#include "position_t.h"


// !!! 初期化では、wheel, body, の構造体を元にパラメータを計算できるようにする
extern void position_initialize(position_t *position);
extern void position_reset(position_t *position);
extern void position_update(int right_encoder_difference,
                            int left_encoder_difference, position_t *position);
// !!! 並進速度の取得
// !!! 回転速度の取得
// !!! 車輪速の取得

extern short position_dir16diff(long target, long current);

#endif /* !POSITION_CALCULATE_H */
