#ifndef QRK_ENCODER_T_H
#define QRK_ENCODER_T_H

/*!
  \file
  \brief エンコーダ

  \author Satofumi KAMIMURA

  $Id: encoder_t.h 1209 2009-08-05 13:11:59Z satofumi $
*/


// エンコーダ分解能 (マイコンの機能で４逓倍する)
#ifndef ENCODER_T_COUNT
#define ENCODER_T_COUNT (512 * 4) // [1]
#endif


//! エンコーダ
typedef struct
{
  char reset;
  char id;                      //!< エンコーダのデバイス ID
  short previous_count;         //!< 前回のエンコーダ値 [1]
  short difference;             //!< エンコーダ値の変化値 [1]
} encoder_t;

#endif /* !QRK_ENCODER_T_H */
