#ifndef QRK_WHEEL_DIRECT_H
#define QRK_WHEEL_DIRECT_H

/*!
  \file
  \brief 車輪を直接制御するためのインターフェース

  \author Satofumi KAMIMURA

  $Id: WheelDirect.h 1383 2009-10-09 03:20:36Z satofumi $
*/

namespace qrk
{
  //! 車輪の直接制御
  class WheelDirect
  {
  public:
    virtual ~WheelDirect(void)
    {
    }


    /*!
      \brief 車輪速の指定

      \param[in] id 車輪 ID
      \param[in] mm_per_sec 移動速度 [mm/sec]
    */
    virtual void setWheelVelocity(int id, long mm_per_sec) = 0;
  };
}

#endif /* !QRK_WHEEL_DIRECT_H */
