#ifndef QRK_PHIDGET_DEVICE_H
#define QRK_PHIDGET_DEVICE_H

/*!
  \file
  \brief Phidget モータドライバの制御

  \author Satofumi KAMIMURA

  $Id: PhidgetDevice.h 1574 2009-12-13 03:53:55Z satofumi $
*/

#include <memory>


namespace qrk
{
  class PhidgetDevice
  {
  public:
    PhidgetDevice(void);
    ~PhidgetDevice(void);

    const char* what(void) const;

    bool connect(void);
    void disconnect(void);
    bool isConnected(void) const;

    void setMotorDuty(int id, unsigned char duty);
    void freeServo(int id);

  private:
    PhidgetDevice(const PhidgetDevice& rhs);
    PhidgetDevice& operator = (const PhidgetDevice& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_PHIDGET_DEVICE_H */
