#ifndef QRK_CONNECT_DEVICE_H
#define QRK_CONNECT_DEVICE_H

/*!
  \file
  \brief 接続の関数

  \author Satofumi KAMIMURA

  $Id: connectDevice.h 1546 2009-11-24 03:42:05Z satofumi $
*/

namespace qrk
{
  class BeegoDrive;
  class UrgDevice;
  class mBeegoDrive;
  class mUrgDevice;


  enum {
    BeegoDriveBaudrate = 115200,
    UrgDeviceBaudrate = 115200,
  };


  bool connectDevice(BeegoDrive& run, const char* device,
                     long baudrate = BeegoDriveBaudrate);
  bool connectDevice(UrgDevice& urg, const char* device,
                     long baudrate = UrgDeviceBaudrate);

  bool connectDevice(mBeegoDrive& run, const char* device,
                     long baudrate = BeegoDriveBaudrate);
  bool connectDevice(mUrgDevice& urg, const char* device,
                     long baudrate = UrgDeviceBaudrate);
}

#endif /* !QRK_CONNECT_DEVICE_H */
