/*!
  \file
  \brief データの受信のみを行った際の CPU 負荷を評価するプログラム

  \author Satofumi KAMIMURA

  $Id: capture_only.cpp 1716 2010-02-21 22:04:16Z satofumi $
*/

#include "SerialDevice.h"
#include "ConnectionUtils.h"
#include <SDL.h>

using namespace qrk;


int main(int argc, char *argv[])
{
  const char device[] = "COM3";
  //const char device[] = "/dev/ttyACM0";

  SerialDevice con;
  if (! con.connect(device, 19200)) {
    printf("SerialDevice::connect: %s\n", con.what());
    exit(1);
  }

  // QT を発行してコマンドを停止させる
  enum { Timeout = 200 };
  con.send("QT\n", 3);
  skip(&con, Timeout);

  // SCIP 2.0 へ変更
  con.send("SCIP2.0\n", 8);
  skip(&con, Timeout);

  // データ取得コマンドを発行
  int first_index = 180;
  int last_index = 900;
  int grouping = 3;

  enum { RequestSize = 16 };
  char request[] = "MDbbbbeeeeggstt\n";

  snprintf(request, RequestSize + 1,
           "MD%04d%04d%02d100\n", first_index, last_index, grouping);

  printf("%s\n", request);

  // データ受信コマンドの送信
  con.send(request, RequestSize);

  // 受信データを読み捨てる
  enum { LineMax = 80 };
  char buffer[LineMax];
  int n;
  while ((n = readline(&con, buffer, LineMax, Timeout)) >= 0) {
    //fprintf(stderr, "%s\n", buffer);
  }

  return 0;
}
