/*!
  \example viewSerialIdSample.cpp

  \brief シリアル ID の取得サンプル

  \author Satofumi KAMIMURA

  $Id: viewSerialIdSample.cpp 1739 2010-03-06 07:43:32Z satofumi $
*/

#include "mUrgDevice.h"
#include "UrgUtils.h"
#include <SDL.h>

using namespace qrk;


int main(int argc, char *argv[])
{
  mUrgDevice urg(argc, argv);
  if (! urg.connect("/dev/ttyACM0")) {
    printf("UrgDevice::connect: %s\n", urg.what());
    exit(1);
  }

  printf("Serial ID: %ld\n", urgSerialId<mUrgDevice>(&urg));

  return 0;
}
