/*!
  \file
  \brief URG のリセットサンプル

  \author Satofumi KAMIMURA

  $Id: rebootUrg.cpp 1739 2010-03-06 07:43:32Z satofumi $
*/

#include "mUrgDevice.h"
#include "delay.h"
#include <cstdlib>

using namespace qrk;
using namespace std;


static void printVersion(mUrgDevice& urg)
{
  // バージョン情報の取得
  vector<string> lines;
  urg.versionLines(lines);
  if (lines.empty()) {
    cerr << "UrgDevice::versionLines: " << urg.what() << endl;
    exit(1);
  }

  // 表示
  for (vector<string>::iterator it = lines.begin();
       it != lines.end(); ++it) {
    cout << *it << endl;
  }
}


int main(int argc, char *argv[])
{
  //const char device[] = "COM3"; /* Windows での例 */
  const char device[] = "/dev/ttyACM0"; /* Linux での例 */

  mUrgDevice urg(argc, argv);

  enum {
    RebootTimes = 10,
    RebootMsec = 7000,         /* [msec] */
  };
  for (int i = 0; i < RebootTimes; ++i) {
    if (! urg.connect(device)) {
      cout << "UrgDevice::connect: " << urg.what() << endl;
      exit(0);
    }

    // バージョン情報の表示
    printVersion(urg);

    // リセット
    urg.reboot();

    // 再起動を待つ
    delay(RebootMsec);
  }

  return 0;
}
