/*!
  \example laserToggleSample.cpp

  \brief レーザ発光の制御サンプル

  \author Satofumi KAMIMURA

  $Id: laserToggleSample.cpp 1739 2010-03-06 07:43:32Z satofumi $
*/

#include "mUrgDevice.h"
#include <SDL.h>

using namespace qrk;


int main(int argc, char *argv[])
{
  mUrgDevice urg(argc, argv);

  if (! urg.connect("/dev/ttyACM0")) {
    printf("UrgDevice::connect: %s\n", urg.what());
    exit(1);
  }

  for (int i = 0; i < 2; ++i) {
    urg.setLaserOutput(UrgDevice::On);
    getchar();

    urg.setLaserOutput(UrgDevice::Off);
    getchar();
  }

  return 0;
}
