/*!
  \example captureIntensitySample.cpp

  \brief 強度データの取得サンプル

  \author Satofumi KAMIMURA

  $Id: intensityScan.cpp 1739 2010-03-06 07:43:32Z satofumi $
*/

#include "mUrgDevice.h"
#include "delay.h"
#include <SDL.h>
#include <cstdlib>
#include <cstdio>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  //const char device[] = "COM4";
  const char device[] = "/dev/ttyACM0";

  mUrgDevice urg(argc, argv);
  if (! urg.connect(device)) {
    printf("UrgDevice::connect: %s\n", urg.what());
    exit(1);
  }
  int scan_msec = urg.scanMsec();
  urg.setCaptureMode(IntensityCapture);
  //urg.setCaptureRange(urg.deg2index(-90), urg.deg2index(+90));
  //urg.setCaptureMode(IntensityCapture);
  //urg.setCaptureSkipLines(2);
  //urg.setCaptureRange(540, 544);

  enum {
    CaptureTimes = 10,
  };

  vector<long> data;
  vector<long> intensity_data;

  long previous_timestamp = 0;
  for (int i = 0; i < CaptureTimes; ++i) {
    long timestamp = 0;
    int data_n = urg.captureWithIntensity(data, intensity_data, &timestamp);
    if (data_n > 0) {
      int front_index = urg.rad2index(0.0);
      printf("%d: %ld [mm] (%ld), %ld [msec] (%ld)\n",
             i, data[front_index], intensity_data[front_index], timestamp,
             timestamp - previous_timestamp);
      previous_timestamp = timestamp;
    } else {
      --i;
      delay(scan_msec);
    }
  }

  return 0;
}
