/*!
  \example groupingSample.cpp

  \brief データ取得間隔の指定サンプル

  \author Satofumi KAMIMURA

  $Id: groupingSample.cpp 1739 2010-03-06 07:43:32Z satofumi $
*/

#include "UrgDevice.h"
#include <SDL.h>
#include <cstdlib>

using namespace qrk;


int main(int argc, char *argv[])
{
  UrgDevice urg;
  if (! urg.connect("/dev/ttyACM0")) {
    printf("UrgDevice::connect: %s\n", urg.what());
    exit(1);
  }

  int degree = 35;
  int index_diff = urg.deg2index(degree) - urg.deg2index(0);
  printf("index %d deg: %d lines\n", degree, index_diff);

  return 0;
}
