/*!
  \example detectDisconnectSample.cpp
  \brief 切断の検出サンプル

  \author Satofumi KAMIMURA

  $Id: detectDisconnectSample.cpp 1739 2010-03-06 07:43:32Z satofumi $
*/

#include "mUrgDevice.h"
#include "ticks.h"
#include "delay.h"
#include <SDL.h>
#include <iostream>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  const char device[] = "/dev/ttyACM0";

  mUrgDevice urg(argc, argv);
  if (! urg.connect(device)) {
    cout << "UrgDevice::connect: " << urg.what() << endl;
    exit(1);
  }
  long scan_msec = urg.scanMsec();

  enum { DetectMsec = 10 * 1000 }; // [msec]
  long first_ticks = ticks();

  vector<long> data;
  while ((ticks() - first_ticks) < DetectMsec) {
    int n = urg.capture(data);
    if (n < 0) {
      cout << "disconnected!" << endl;
      break;
    }
    cout << "n = " << n << endl;
    delay(scan_msec);
  }

  return 0;
}
