/*!
  \file
  \brief Sample of reboot URG

  \author Satofumi KAMIMURA

  $Id: reboot_urg.c 1733 2010-03-06 01:19:49Z satofumi $
*/

#include "urg_ctrl.h"
#include "urg_delay.h"
#include <stdio.h>
#include <stdlib.h>


static void urg_exit(urg_t *urg, const char *message)
{
  printf("%s: %s\n", message, urg_error(urg));
  urg_disconnect(urg);

#ifdef MSC
  getchar();
#endif
  exit(1);
}


static void printVersion(urg_t *urg)
{
  enum {
    LinesMax = 5,
  };

  char buffer[LinesMax][UrgLineWidth];
  char *lines[LinesMax];
  int ret;
  int i;

  /* Get version information */
  for (i = 0; i < LinesMax; ++i) {
    lines[i] = buffer[i];
  }
  ret = urg_versionLines(urg, lines, LinesMax);
  if (ret < 0) {
    urg_exit(urg, "urg_getVersion");
  }

  /* Display */
  for (i = 0; i < LinesMax; ++i) {
    printf("%s\n", lines[i]);
  }
  printf("\n");
}


int main(int argc, char *argv[])
{
  enum {
    RebootTimes = 10,
    RebootMsec = 7000,         /* [msec] */
  };

#ifdef WINDOWS_OS
  const char device[] = "COM4"; /* For Windows */
#else
  const char device[] = "/dev/ttyACM0"; /* For Linux */
#endif

  int ret;
  int i;

  urg_t urg;

  for (i = 0; i < RebootTimes; ++i) {
    ret = urg_connect(&urg, device, 115200);
    if (ret < 0) {
      urg_exit(&urg, "urg_connect()");
    }

    printVersion(&urg);
    urg_reboot(&urg);

    /* wait for rebooting */
    urg_delay(RebootMsec);
  }

  urg_disconnect(&urg);

  return 0;
}
