/*!
  \file
  \brief GD でのデータ取得サンプル

  \author Satofumi KAMIMURA

  $Id: gd_capture.cpp 1528 2009-11-17 23:32:01Z satofumi $
*/

#include "UrgDevice.h"
#include <iostream>
#include <cstdlib>

using namespace qrk;
using namespace std;


int main(int argc, char *argv[])
{
  static_cast<void>(argc);
  static_cast<void>(argv);

  const char device[] = "/dev/ttyACM0";

  UrgDevice urg;
  if (! urg.connect(device)) {
    cout << "UrgDevice::connect(): " << urg.what() << endl;
    exit(1);
  }

  urg.setRequestMode(UrgDevice::GD_Capture);
  //urg.setSkipLines(2);

  vector<long> data;
  long timestamp = 0;

  enum { CaptureTimes = 10 };
  for (size_t i = 0; i < CaptureTimes; ++i) {
    urg.requestData();
    if (! urg.receiveData(data, &timestamp)) {
      cout << "UrgDevice::receiveData(): " << urg.what() << endl;
      exit(1);
    }

    size_t n = data.size();

    cout << "n = " << n << endl;
    cout << "timestamp = " << timestamp << endl;
    for (size_t j = 0; j < n; ++j) {
      cout << data[j] << ", ";
    }
    cout << endl;
  }
  return 0;
}
