/*!
  \file
  \brief メディアンを適用した距離データを生成する

  \author Satofumi KAMIMURA

  $Id: medianPoints.cpp 1447 2009-10-25 07:13:40Z satofumi $
*/

#include "medianPoints.h"
#include "MovingMedian.h"

using namespace qrk;
using namespace std;


bool qrk::medianPoints(distance_t& distance_group, const range_t& range,
                       const std::vector<long>& data, size_t median_points)
{
  // 最初の点はメディアンの影響を受けないため、登録しない
  const int ignore_points = median_points / 2;

  distance_group.range = range;
  if ((range.first + ignore_points) >= range.last) {
    distance_group.range.first = range.last;
    return false;
  }
  distance_group.range.first += ignore_points;

  int begin_index = range.first;
  int end_index = range.last;
  MovingMedian<long> median(median_points, data[begin_index]);

  for (int i = begin_index; i < end_index; ++i) {
    long distance = median.push_back(data[i]);
    if (i >= (begin_index + ignore_points)) {
      distance_group.data.push_back(distance);
    }
  }

  // 点の位置が最後に処理したデータ側にずれるので、補正する
  distance_group.range.first -= ignore_points;
  distance_group.range.last -= ignore_points;

  return true;
}
