#ifndef QRK_FEATURE_POINT_T_H
#define QRK_FEATURE_POINT_T_H

/*!
  \file
  \brief 特徴点

  \author Satofumi KAMIMURA

  $Id: featurePoint_t.h 1447 2009-10-25 07:13:40Z satofumi $
*/

#include "Point.h"


namespace qrk
{
  //! 特徴点の種類
  typedef enum {
    RightAngle = 0,               //!< 90 [deg] くらいのエッジ
    ReflexAngle,                  //!< 270 [deg] くらいのエッジ
    ThinPoll,                     //!< 細い柱
    Poll,                         //!< 柱
    Unknown,
  } FeaturePointType;


  //! 特徴点
  typedef struct
  {
    Point<long> point;
    FeaturePointType type;
    long radius;                  //!< 柱のときの半径
  } featurePoint_t;
}

#endif /* !QRK_FEATURE_POINT_T_H */
