#ifndef QRK_DETECT_POLES_H
#define QRK_DETECT_POLES_H

/*!
  \file
  \brief 柱の検出

  \author Satofumi KAMIMURA

  $Id: detectPoles.h 1565 2009-12-06 04:49:51Z satofumi $
*/

#include "Position.h"
#include "pole_t.h"
#include "range_t.h"
#include <vector>


namespace qrk
{
  class RangeFinder;

  enum {
    PolesDefaultLength = -1,
  };


  void detectPoles(std::vector<pole_t>& poles,
                   const RangeFinder& lrf,
                   const std::vector<long>& data,
                   const std::vector<range_t>& ranges,
                   const Position<long>& position,
                   long max_radius_mm = 400,
                   long min_length = PolesDefaultLength,
                   long max_length = PolesDefaultLength);
}

#endif /*! QRK_DETECT_POLES_H */
