#ifndef QRK_DETECT_LINES_H
#define QRK_DETECT_LINES_H

/*!
  \file
  \brief 線分の検出

  \author Satofumi KAMIMURA

  $Id: detectLines.h 1519 2009-11-16 00:11:45Z satofumi $
*/

#include "line_t.h"
#include "range_t.h"
#include "Position.h"
#include <vector>


namespace qrk
{
  class RangeFinder;

  enum {
    LinesDefaultLength = -1,
  };


  void detectLines(std::vector<line_t>& lines,
                   const RangeFinder& lrf,
                   const std::vector<long>& data,
                   const std::vector<range_t>& ranges,
                   const Position<long>& position,
                   long line_length_mm = 300,
                   long min_length = LinesDefaultLength,
                   long max_length = LinesDefaultLength);
}

#endif /* !QRK_DETECT_LINES_H */
