#ifndef QRK_AVERAGE_POINTS_H
#define QRK_AVERAGE_POINTS_H

/*!
  \file
  \brief メディアンを適用した距離データを生成する

  \author Satofumi KAMIMURA

  $Id: averagePoints.h 1402 2009-10-11 12:45:16Z satofumi $
*/

#include "distance_t.h"


namespace qrk
{
  /*!
    \brief 移動平均の適用

    \param[out] distance_group 部分的な距離データ
    \param[in] range データの範囲
    \param[in] data データ
    \param[in] average_points 移動平均の幅

    \retval true 正常に適用
    \retval false 適用に失敗
  */
  bool averagePoints(distance_t& distance_group, const range_t& range,
                    const std::vector<long>& data, size_t average_points = 4);
};

#endif /* !QRK_AVERAGE_POINTS_H */
