/*!
  \file
  \brief PointMap のテスト

  \author Satofumi KAMIMURA

  $Id: TestPointMap.cpp 1470 2009-10-30 01:06:27Z satofumi $
*/

#include "TestPointMap.h"
#include "PointMap.h"

using namespace qrk;
using namespace std;


CPPUNIT_TEST_SUITE_REGISTRATION(TestPointMap);
CPPUNIT_TEST_SUITE_NAMED_REGISTRATION(TestPointMap, "TestPointMap");


namespace
{
  void printPoints(const vector<size_t>& ids, const PointMap& point_map)
  {
    fprintf(stderr, "\n");
    for (vector<size_t>::const_iterator it = ids.begin();
         it != ids.end(); ++it) {
      Point<long> point = point_map.point(*it);
      fprintf(stderr, "(%ld, %ld), ", point.x, point.y);
    }
    fprintf(stderr, "\n");
  }
}


void TestPointMap::nearPointsTest(void)
{
  PointMap point_map(2);
  point_map.add(Point<long>(0, 0));
  point_map.add(Point<long>(1, 0));
  point_map.add(Point<long>(2, 0));
  point_map.add(Point<long>(3, 0));
  point_map.add(Point<long>(4, 0));

  vector<size_t> ids;
  point_map.nearPoints(ids, Point<long>(0, 0), 2);
  //printPoints(ids, point_map);
  CPPUNIT_ASSERT_EQUAL(4, static_cast<int>(ids.size()));

  ids.clear();
  point_map.nearPoints(ids, Point<long>(2, 0), 2);
  //printPoints(ids, point_map);
  CPPUNIT_ASSERT_EQUAL(5, static_cast<int>(ids.size()));

  ids.clear();
  point_map.nearPoints(ids, Point<long>(6, 0), 2);
  //printPoints(ids, point_map);
  CPPUNIT_ASSERT_EQUAL(static_cast<size_t>(1), ids.size());
}


void TestPointMap::margeTest(void)
{
  size_t id = 1;
  PointMap point_map(2);
  point_map.add(Point<long>(300, 0), id);
  CPPUNIT_ASSERT_EQUAL(static_cast<long>(300), point_map.point(id).x);

  point_map.marge(id, Point<long>(0, 0));
  CPPUNIT_ASSERT_EQUAL(static_cast<long>(150), point_map.point(id).x);

  point_map.marge(id, Point<long>(0, 0));
  CPPUNIT_ASSERT_EQUAL(static_cast<long>(100), point_map.point(id).x);
}
