#ifndef QRK_POINT_MAP_H
#define QRK_POINT_MAP_H

/*!
  \file
  \brief 点群の管理

  \author Satofumi KAMIMURA

  $Id: PointMap.h 1949 2011-05-06 07:18:01Z satofumi $
*/

#include "Point.h"
#include <vector>
#include <memory>
#include <cstddef>


namespace qrk
{
  //! 点群の管理クラス
  class PointMap
  {
  public:
    PointMap(void);
    PointMap(size_t grid_width);
    ~PointMap(void);

    void clear(void);

    //! 点の追加
    void add(const Point<long>& point, size_t id = 0);

    bool exists(size_t id) const;

    //! 点の位置を更新
    void marge(size_t id, const Point<long>& point);

    Point<long> point(size_t id) const;

    void ids(std::vector<size_t>& ids) const;

    //! 指定した位置周辺の点群を受け取る
    // !!! メソッドに const を付加する
    void nearPoints(std::vector<size_t>& ids,
                    const Point<long>& point, long radius);

  private:
    PointMap(const PointMap& rhs);
    PointMap& operator = (const PointMap& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* !QRK_POINT_MAP_H */
