#ifndef QRK_OBJECT_MAP_BUFFER_H
#define QRK_OBJECT_MAP_BUFFER_H

/*!
  \file
  \brief 環境マップのバッファ

  登録した物体が、移動しているかを判定するために用いる。

  \author Satofumi KAMIMURA

  $Id: ObjectMapBuffer.h 1949 2011-05-06 07:18:01Z satofumi $
*/

#include <memory>
#include <cstddef>


namespace qrk
{
  class ObjectMap;


  class ObjectMapBuffer
  {
  public:
    ObjectMapBuffer(void);
    ~ObjectMapBuffer(void);

    bool empty(void) const;
    size_t size(void) const;
    ObjectMap* at(size_t index) const;
    ObjectMap* front(void) const;
    ObjectMap* back(void) const;
    void pop_back(void);

    long timestamp(size_t index) const;

    size_t index(long timestamp) const;

    size_t lastId(void) const;

    // !!!

  private:
    ObjectMapBuffer(const ObjectMapBuffer& rhs);
    ObjectMapBuffer& operator = (const ObjectMapBuffer& rhs);

    struct pImpl;
    std::auto_ptr<pImpl> pimpl;
  };
}

#endif /* ! QRK_OBJECT_MAP_BUFFER_H */
